/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.apps.config;

import filenet.vw.apps.config.VWConfigCore;
import filenet.vw.apps.config.resources.VWResource;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.IVWSplashWindowListener;
import filenet.vw.toolkit.utils.VWBaseAppLauncherApplet;
import filenet.vw.toolkit.utils.VWSplashWindow;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;

public class VWConfigApplet
extends VWBaseAppLauncherApplet
implements IVWSplashWindowListener {
    private VWSplashWindow m_splashWindow = null;
    private VWConfigCore m_configCore = null;

    public void init() {
        try {
            super.init();
            this.m_splashWindow = new VWSplashWindow(null);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void start() {
        if (this.m_splashWindow != null) {
            this.m_splashWindow.start(this, 1000);
        }
    }

    public void destroy() {
        try {
            if (this.m_configCore != null && this.isActive()) {
                this.m_configCore.destroy();
            }
            super.destroy();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void startProcessing() {
        try {
            if (!this.m_sessionInfo.verifyLogon(VWResource.s_pwConfigurationGroup)) {
                this.abort();
                return;
            }
            try {
                if (!this.m_sessionInfo.isAllowedToRunConfigurationApp()) {
                    VWMessageDialog.showOptionDialog(this.m_sessionInfo.getParentFrame(), VWResource.s_insufficentRights, 1);
                    this.abort();
                    return;
                }
            }
            catch (Exception ex) {
                this.abort();
                return;
            }
            if (this.m_splashWindow != null) {
                this.m_splashWindow.setVisible(true);
            }
            this.m_configCore = new VWConfigCore();
            this.m_configCore.init(this.m_sessionInfo);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }
}

